/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.listener;

import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.bukkit.listener.PlayerJoin;
import net.skinsrestorer.shared.listeners.LoginProfileEvent;
import net.skinsrestorer.shared.listeners.LoginProfileListener;
import net.skinsrestorer.shared.storage.Config;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.plugin.Plugin;

public class PlayerResourcePackStatus
extends LoginProfileListener
implements Listener {
    private final SkinsRestorer plugin;
    private final boolean isOnlineMode = Bukkit.getOnlineMode();

    @EventHandler
    public void onResourcePackStatus(PlayerResourcePackStatusEvent event) {
        if (!Config.RESOURCE_PACK_FIX) {
            return;
        }
        PlayerJoin.setResourcePack(true);
        LoginProfileEvent profileEvent = this.wrap(event);
        if (this.handleSync(profileEvent)) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.handleAsync(profileEvent).ifPresent(name -> {
            try {
                this.plugin.getSkinsRestorerAPI().applySkin(new PlayerWrapper(event.getPlayer()), (String)name);
            }
            catch (SkinRequestException e) {
                this.plugin.getSrLogger().debug(e);
            }
        }));
    }

    private LoginProfileEvent wrap(final PlayerResourcePackStatusEvent event) {
        return new LoginProfileEvent(){

            @Override
            public boolean isOnline() {
                return Bukkit.getOnlineMode();
            }

            @Override
            public String getPlayerName() {
                return event.getPlayer().getName();
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
    }

    @Override
    public SkinsRestorer getPlugin() {
        return this.plugin;
    }

    public boolean isOnlineMode() {
        return this.isOnlineMode;
    }

    public PlayerResourcePackStatus(SkinsRestorer plugin) {
        this.plugin = plugin;
    }
}

